#include <debug.h>
#include <makros.h>
#include <TimerOne.h>
#include "cube333.h"

Cube333 cube333;

void setup() {
  initDebug();
  dbgOutLn("Start cubing...");
  cube333.initCube();

  Timer1.initialize(200);
  Timer1.attachInterrupt(updateCube);
}

void updateCube() {
  cube333.updateCube();
}

void loop() {
  // put your main code here, to run repeatedly:
  for (byte x = 0; x < 16; x++) {
    cube333.setBrightness(x);
    cube333.setLED(1, 1, 2, 1);
    delay(100);
  }
}
