#include <Servo.h>
#define debug
#include "debug.h"

/*
  Useless Switch

  Dieses kleine Programm schaltet einen Schalter wieder aus, den der Benutzer eingeschaltet hat.
*/

const byte LED = 6;
const byte SERVO = 5;
const byte SWITCH = 2;

Servo servo;

typedef void (*Reaction) ();

/*
    Diese Funktion wird nur einmal beim Start des Arduinos ausgeführt.
    Hier schreibt man die Dinge hin, die nur einmal am Anfang ausgeführt werden sollen
*/
void setup() {
  // Der Pin, an dem die LED hängt definieren wir als Ausgang.
  pinMode(LED, OUTPUT);

  // Der Pin, an dem der Schalter hängt definieren wir als Eingang.
  pinMode(SWITCH, INPUT_PULLUP);

  // Und wir brauchen noch einen Servo.
  servo.attach(SERVO);
  servo.write(0);
  digitalWrite(LED, LOW);    // Jetzt schalten wir die LED wieder aus (der Pin geht auf Masse)
  randomSeed(analogRead(0));
  initDebug();
  dbgOutLn("\nstarted");
}

/*
  Diese Funktion wird automatisch immer wieder ausgeführt.
  D.h. sobald unser Programm unten angekommen ist, fängt es automatisch oben wieder an.
*/
void loop() {
  if (getSwt()) {
    dbgOut('#');
    digitalWrite(LED, HIGH);   // Jetzt schalten wir die LED an (der Pin geht auf +5V)
    byte choise = random(6);
    dbgOut2(choise, DEC);
    switch (choise) {
      case 1:
        simpleSlow();
        break;
      case 2:
        simpleFox();
        break;
      case 3:
        waitFox();
        break;
      case 4:
        slowWaitFox();
        break;
      case 5:
        brummen();
        break;
      default:
        simpleFast();
    }
  }
}

void simpleFast() {
  if (getSwt()) {
    dbgOut('F');
    servo.write(180);
    while (getSwt()) {
      delay(10);
    }
    digitalWrite(LED, LOW);    // Jetzt schalten wir die LED wieder aus (der Pin geht auf Masse)
    // Und jetzt wieder zurück auf die Ursprungsstellung
    servo.write(0);
  }
}

void simpleSlow() {
  if (getSwt()) {
    dbgOut('S');
    digitalWrite(LED, HIGH);   // Jetzt schalten wir die LED an (der Pin geht auf +5V)
    byte angle = 0;
    while (getSwt()) {
      angle += 1;
      if (angle < 180) {
        servo.write(angle);
      } else {
        angle = 180;
      }
      delay(5);
    }
    digitalWrite(LED, LOW);    // Jetzt schalten wir die LED wieder aus (der Pin geht auf Masse)
    // wir fahren dem Servo noch 5° weiter, damit der Schalter sicher schaltet.
    byte i = 0;
    while (i < 5) {
      i++;
      angle += 1;
      if (angle < 180) {
        servo.write(angle);
      } else {
        angle = 180;
      }
      delay(5);
    }
    // Und jetzt wieder zurück auf die Ursprungsstellung
    servo.write(0);
  }
}

void simpleFox() {
  if (getSwt()) {
    dbgOut('F');
    digitalWrite(LED, HIGH);   // Jetzt schalten wir die LED an (der Pin geht auf +5V)
    byte angle = 0;
    servo.write(75);
    byte wait = 50;
    while (getSwt() && (wait > 0)) {
      wait--;
      delay(10);
    }
    if (getSwt()) {
      simpleFast();
    }
  }
}

void waitFox() {
  if (getSwt()) {
    dbgOut('WF');
    digitalWrite(LED, HIGH);   // Jetzt schalten wir die LED an (der Pin geht auf +5V)
    byte angle = 0;
    delay(2000);
    servo.write(45);
    delay(1000);
    servo.write(0);
    delay(1000);
    if (getSwt()) {
      simpleFast();
    }
  }
}

void slowWaitFox() {
  if (getSwt()) {
    dbgOut("SWF");
    digitalWrite(LED, HIGH);   // Jetzt schalten wir die LED an (der Pin geht auf +5V)
    delay(1000);
    int angle = 0;
    while (angle < 65) {
      angle += 1;
      servo.write(angle);
      delay(5);
    }
    delay(1000);
    while (angle > 25) {
      angle -= 1;
      servo.write(angle);
      delay(10);
    }
    delay(1000);
    while (angle < 88) {
      angle += 1;
      servo.write(angle);
      delay(20);
    }
    delay(1000);
    while (angle > 45) {
      angle -= 2;
      servo.write(angle);
      delay(5);
    }
    servo.write(0);
    delay(1000);
    dbgOut(".");
    servo.write(180);
    dbgOut(".");
    while (getSwt()) {
      delay(10);
    }
    dbgOut(".");
    digitalWrite(LED, LOW);    // Jetzt schalten wir die LED wieder aus (der Pin geht auf Masse)
    // Und jetzt wieder zurück auf die Ursprungsstellung
    dbgOut(".");
    servo.write(0);
  }
}

void brummen() {
  if (getSwt()) {
    dbgOut("B");
    digitalWrite(LED, HIGH);   // Jetzt schalten wir die LED an (der Pin geht auf +5V)
    for (byte i = 0; i < 20; i++) {
      servo.write(10);
      delay(50);
      servo.write(0);
      delay(50);
    }

    servo.write(180);
    dbgOut(".");
    while (getSwt()) {
      delay(10);
    }
    dbgOut(".");
    digitalWrite(LED, LOW);    // Jetzt schalten wir die LED wieder aus (der Pin geht auf Masse)
    // Und jetzt wieder zurück auf die Ursprungsstellung
    dbgOut(".");
    servo.write(0);
  }
}

bool getSwt () {
  return digitalRead(SWITCH) == 0;
}
