/*
 Akkuwaechter.ino - Programm zur Überwachung eines Akkus - Version 0.1 
 
 Copyright (c) 2013 Wilfried Klaas.  All right reserved.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/*
Akkuwächter.
 Kleines Beispiel wie man Spannungen an den analogen Eingängen mißt.
 Mißt den Wert am Eingang A0, Unterspannungsanzeige an der Board LED
 */
// LED und Akkupins.
const byte LED = 13;
const byte AKKU = 0;

// Konstanten für die verschiedenen Akkutypen
const int NIMH_6 = 985;
const int NIMH_7 = 987;
const int LIPO_2 = 985;
const int LIPO_3 = 949;
const int LIPO_4 = 976;
const int AKKU_6 = 988;
const int AKKU_12 = 979;

// Welcher Akku soll verwendet werden.
const byte AKKU_VALUE = LIPO_2;

// die setup routine wird beim start aufgerufen
void setup() {
  pinMode(LED, OUTPUT);
}

// die loop routine wird immer wieder aufgerufen
void loop() {
  // Wert vom Eingang lesen
  int sensorValue = analogRead(AKKU);
  if (sensorValue < AKKU_VALUE) {
    unsigned long time = millis();
    if ((time % 1000) < 500) {
      digitalWrite(LED, HIGH);
    } 
    else {
      digitalWrite(LED, LOW);
    }  
  } 
  else {
    digitalWrite(LED, LOW);
  }
}
