/*
 Ampel_1.ino - Programm zur Steuerung einer einfachen Ampel - Version 0.1 
 
 Copyright (c) 2013 Wilfried Klaas.  All right reserved.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/* Einfache Ampel ohne delay. */
const byte LED_R = 10;
const byte LED_Y = 11;
const byte LED_G = 12;
const word D_RED = 2000;
const word D_RED_YELLOW = 2500;
const word D_GREEN = 4500;
const word D_YELLOW = 5000;

void setup() {
  pinMode(LED_R, OUTPUT);
  pinMode(LED_Y, OUTPUT);
  pinMode(LED_G, OUTPUT);
}

void loop() {
  long zeit = millis() % D_YELLOW;
    if ((zeit > 0) && (zeit < D_RED)) {
      // Ampel zeigt rot
      digitalWrite(LED_R, HIGH);
      digitalWrite(LED_Y, LOW);
      digitalWrite(LED_G, LOW);
    } else  if ((zeit > D_RED) && (zeit < D_RED_YELLOW)) {
      // Ampel zeigt rot, gelb
      digitalWrite(LED_R, HIGH);
      digitalWrite(LED_Y, HIGH);
      digitalWrite(LED_G, LOW);
    } else  if ((zeit > D_RED_YELLOW) && (zeit < D_GREEN)) {
      // Ampel zeigt grün
      digitalWrite(LED_R, LOW);
      digitalWrite(LED_Y, LOW);
      digitalWrite(LED_G, HIGH);
    } else  if ((zeit > D_GREEN) && (zeit < D_YELLOW)) {
      // Ampel zeigt gelb
      digitalWrite(LED_R, LOW);
      digitalWrite(LED_Y, HIGH);
      digitalWrite(LED_G, LOW);
    }
}
