/*
 BlinkNoDelay.ino - Blinken einer LED - Version 0.1 
 
 Copyright (c) 2013 Wilfried Klaas.  All right reserved.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/*
läßt die Board LED blinken, wenn man Pin 1 z.B. mit einem Taster an Masse legt. Ohne delay.
*/
const byte LED = 13;
const byte TASTE = 1;

void setup() {
  pinMode(LED, OUTPUT);
  pinMode(TASTE, INPUT_PULLUP);
}

void loop() {
  if (digitalRead(TASTE) == 0) {
    // Taste gedrückt, Blinker einschalten
    if ((millis() % 1000) < 500) {
      // LED einschalten
      digitalWrite(LED, HIGH);
    } 
    else {
      // LED ausschalten
      digitalWrite(LED, LOW);
    }
  } else {
    // LED ausschalten
    digitalWrite(LED, LOW);
  }
}
