//#define debug
#include <Servo.h>
#include <debug.h>
#include <makros.h>
#include <RCReceive.h>
/*
 Failsafe.ino - Failsafe für 2 Kanäle - Version 0.1 
 
 Copyright (c) 2013 Wilfried Klaas.  All right reserved.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
Das Programm implementiert einen Failsave für 2 Empfängerkanäle.
 Dabei werden die Werte vom Empfänger ständig überwacht. Solange 
 keine Störungen vorliegen, werden die Signale vom Empfänger 
 einfach an die angeschlossenen Geräte (Servos, Fahrregler (ESC), 
 Schaltbausteine) durchgereicht. Wird ein Fehler detektiert, 
 z.B. der Ausfall des Senders durch Störungen oder durch zu
 geringe Reichweite werden die angeschlossenen Geräte mit einem 
 Standartwert versorgt. 
 Zusätzlich wird den Fehlerfall durch das Blinken einer LED 
 signalisieren. 
 Sobald das Empfängersignal wieder stabil anliegt, wird dieses 
 auch wieder druchgeleiten.
 */

const byte LED = 13;
const byte SERVO_1 = 9;
const byte SERVO_2 = 10;
const byte PIN_RC_1 = 2; 
const byte PIN_RC_2 = 3; 

const byte FAILSAFE_1 = 90; 
const byte FAILSAFE_2 = 90; 

RCReceive rcReceiver1;
RCReceive rcReceiver2;
Servo servo1;
Servo servo2;
boolean error;

void setup() {
  rcReceiver1.attach(PIN_RC_1);
  rcReceiver2.attach(PIN_RC_2);

  servo1.attach(SERVO_1);
  servo1.write(FAILSAFE_1);

  servo2.attach(SERVO_2);
  servo2.write(FAILSAFE_2);

  pinMode(LED , OUTPUT);
}

void loop() {
  error = false;
  // Aktuellen RC-Wert lesen
  rcReceiver1.poll();
  rcReceiver2.poll();

  // Nullpunktsbestimmung ?
  if (rcReceiver1.hasNP() && !rcReceiver1.hasError()) {
    doWork(rcReceiver1, servo1);
  } 
  else if (rcReceiver1.hasError()) {
    // Fehlerbehandlung failsafe oder sowas...
    servo1.write(FAILSAFE_1);
    error = true;  
  }  

  // Nullpunktsbestimmung ?
  if (rcReceiver2.hasNP() && !rcReceiver2.hasError()) {
    doWork(rcReceiver2, servo2);
  } 
  else if (rcReceiver2.hasError()) {
    // Fehlerbehandlung failsafe oder sowas...
    servo2.write(FAILSAFE_2);
    error = true;  
  }  

  if (error) {
    if ((millis() % 1000) < 500) {
      digitalWrite(LED, HIGH);
    } 
    else {
      digitalWrite(LED, LOW);
    }          
  } 
  else {
    digitalWrite(LED, LOW);
  }
}

void doWork(RCReceive rcReceiver, Servo servo) {
  byte value = rcReceiver.getValue();
  value = map(value, 0, 255, 0, 180);
  servo.write(value);
}


