#include <debug.h>
#include <makros.h>
#include <RCReceive.h>
#include <Servo.h>
/*
 Kreuzmischer.ino - Programm Kreuzmischer, V-Mischer - Version 0.1 
 
 Copyright (c) 2013 Wilfried Klaas.  All right reserved.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 Kreuzmischer. Kanal 1 ist Geschwindigkeit, Kanal 2 ist Steuerung.
 Der Empfänger wird vom Pin 2 und 3 gelesen, 
 */

// Hardwareanbindung für Arduino Hardware
// Empfängerkanäle
const byte PIN_RC_THR = 2; // das ist INT 0 aber Pin 2!!!!
const byte PIN_RC_STE = 3; // das ist INT 1 aber Pin 3!!!!

// Modus Soft oder Hard
const byte PIN_MODE = 4;
const byte PIN_REVERS_1 = 7;
const byte PIN_REVERS_2 = 8;

// Ausgänge
const byte SERVO_1 = 9; // PWM Kanal 
const byte SERVO_2 = 10; // PWM Kanal
const byte LED = 13; // LED auf dem Board

// Ab hier nitte nichts mehr ändern.
RCReceive escReceiver;
RCReceive servoReceiver;

Servo a1, a2;

void setup() {
  // Kanäle auf Ausgang, und dann deaktivieren
  pinMode(LED, OUTPUT);
  digitalWrite(LED, LOW);

  // Eingang Modus
  pinMode(PIN_MODE, INPUT_PULLUP); 
  pinMode(PIN_REVERS_1, INPUT_PULLUP); 
  pinMode(PIN_REVERS_2, INPUT_PULLUP); 

  // Eingang für RC mit Interrupthandler registrieren
  escReceiver.attachInt(PIN_RC_THR);
  servoReceiver.attachInt(PIN_RC_STE);

  // Servos definieren
  a1.attach(SERVO_1);
  a2.attach(SERVO_2);

  a1.write(90);
  a2.write(90);    
}

void loop() {
  if (escReceiver.hasError() || servoReceiver.hasError()) {
    a1.write(90);
    a2.write(90);    
  }
  else if (escReceiver.hasNP() && servoReceiver.hasNP()) {
    doWork();
  }
}

/*
Modus Soft, RC Werte werden jeweils halbiert und dann addiert.
Modus Hard, RC Werte werden addiert und dann beschränkt.
 */
void doWork() {
  // Werte holen
  int escValue = escReceiver.getValue();
  int servoValue = servoReceiver.getValue();

  // Nullpunkte festlegen
  escValue = escValue - escReceiver.getNP();
  servoValue = servoValue - servoReceiver.getNP();

  // Hier wird zwischen hard und soft unterschieden.
  if (digitalRead(PIN_MODE) == 0) {
    // jetzt Wertebereich verkleinern
    escValue = escValue / 2;
    servoValue = servoValue / 2;
  }  

  // die eigentliche Berechnung
  int servo1 = escValue + servoValue;
  int servo2 = escValue - servoValue;

  // Und damit das nicht aus dem Ruder läuft, etwas begrenzen
  servo1 = constrain(servo1, -128, 128);
  servo2 = constrain(servo2, -128, 128);

  if (digitalRead(PIN_REVERS_1) == 0) {
    // Servokanal 1 umkehren
    servo1 = servo1 * -1;
  }

  if (digitalRead(PIN_REVERS_2) == 0) {
    // Servokanal 1 umkehren
    servo2 = servo2 * -1;
  }

  // Nullpunkte wieder hinzu
  servo1 = servo1 + 128;
  servo2 = servo2 + 128;

  // Auf den Servo umsetzen
  servo1 = map(servo1,0, 255,0,180);
  servo2 = map(servo2,0, 255,0,180);

  // und einstellen
  a1.write(servo1);
  a2.write(servo2);
}
