#include <RCReceive.h>
#include <debug.h>
#include <makros.h>
#include <Servo.h>
/*
 ServoRevers.ino - Servorevers und Servowegbegrenzung - Version 0.1 
 
 Copyright (c) 2013 Wilfried Klaas.  All right reserved.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

/*
 Servorevers und Servowegbegrenzung. Der Empfänger wird vom Pin 2.
 */

// Hardwareanbindung für Arduino Hardware, Empfängerkanäle
const byte PIN_RC = 2;

// Ausgänge
const byte SERVO = 9; // PWM Kanal 

// Wir halbieren mal den Servoweg...
const byte MAX_SERVO = 45;
const byte MIN_SERVO = 135;

// und wir reversieren oder auch nicht
const boolean REVERS = true;

// ------------------------------------------------------------
// AB HIER BITTE NIX MEHR ÄNDERN
// ------------------------------------------------------------

RCReceive rcReceiver;

Servo servo;

void setup() {
  // Eingang für RC
  rcReceiver.attach(PIN_RC);

  // Servo definieren
  servo.attach(SERVO);
}

void loop() {
  // Werte für das Steuerservo holen
  rcReceiver.poll();

  // Nullpunktbestimmung ?
  if (rcReceiver.hasNP() && !rcReceiver.hasError()) {
    doWork();
  } 
  else if (rcReceiver.hasError()) {
    // Fehlerbehandlung failsafe
    servo.write(MIN_SERVO);  
  }
}

/*
Modus Soft berechnung, Werte werden jeweils halbiert und dann addiert.
 */
void doWork() {
  // Werte holen
  int servo1 = rcReceiver.getValue();

  // Nullpunkte festlegen
  servo1 = servo1 - rcReceiver.getNP();

  // die eigentliche Berechnung
  if (REVERS) {
    servo1 = -1 * servo1;
  }

  // Und damit das nicht aus dem Ruder läuft, etwas begrenzen
  servo1 = constrain(servo1, -128, 128);

  // Auf den Servo umsetzen und begrenzen
  servo1 = map(servo1, -128, 128, MIN_SERVO, MAX_SERVO);

  // und einstellen
  servo.write(servo1);
}


