#include <Servo.h>
/*
  Servotester.ino - Test eines Servos  - Version 0.1
 
 Copyright (c) 2012 Wilfried Klaas.  All right reserved.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/*
 Servotester. 
 der Servoausgang sind auf Pin 5. 
 Zum Einstellen des Wertes dient ein Potie an dem analogen Eingang 0. 
*/

// Ausgänge
const byte SERVO = 5; // Servo Kanal 

// Eingänge (analogen Eingänge)
const byte PIN_POTI = 0;

// ********** Variablen **********
Servo servo;

// Zwischenspeicher

void setup() {
  // analogreferenz auf 5V
  analogReference(DEFAULT);
  // Servo auf den Ausgang
  servo.attach(SERVO);
  // und direkt mal in die Nullstellung fahren
  servo.write(0);
}

void loop() {
  // Lesen der aktuellen Einstellung
  int value = analogRead(PIN_POTI);
  // Mappen auf den Wertebereich des Servos
  value = map(value,0, 1024,0,180);
  // Schreiben des aktuellen Wertes in den Servo
  servo.write(value);
  // Verzögerung
  delay(100);
}

