/*
  knightrider.ino - Knightrider  - Version 0.1
 
 Copyright (c) 2012 Wilfried Klaas.  All right reserved.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/*
Knightrider Lauflicht mit 8 LED's an den Ausgängen D0..D7.
 1 Taster zum Einschalten an D8.
 */

// das ist die aktuelle Position des Lichtes
const byte MAX_LED = 7;
int pos = MAX_LED / 2;
boolean up = true;

void setup() {
  // Alle LED's als OUTPUT Pins 
  for (int i = 0; i <= MAX_LED; i++) {
    pinMode(i, OUTPUT);
  }
  pinMode(8, INPUT_PULLUP);
}

void loop() {
  if (digitalRead(8) == 0) {
    // Knopf gedrückt, jetzt geht's los
    if (up) {
      pos++;    
      if (pos > MAX_LED) {
        // Richtung umkehren
        up = false;
        pos = MAX_LED;
      }
    }
    else {
      pos--;
      if (pos < 0) {
        // Richtung umkehren
        up = true;
        pos = 0;
      }
    }

    // jetzt die richtigen LED's anschalten
    for (int i = 0; i <= MAX_LED; i++) {
      // erstmal alles aus
      digitalWrite(i, LOW);

      // die richtige Position muss immer leuchten
      if (i == pos) {
        digitalWrite(i, HIGH);
      }
      // Beim Hochlaufen soll auch die LED hinter der aktuellen leuchten
      if (up && (i == (pos - 1))) {
        digitalWrite(i, HIGH);      
      }
      // Beim Runterlaufen soll auch die LED vor der aktuellen leuchten
      if (!up && (i == (pos + 1))) {
        digitalWrite(i, HIGH);      
      }
    }    
    delay(200);
  } 
  else {
    // Knopf nicht gedrückt, alles ausmachen
    for (int i = 0; i <= 7; i++) {
      digitalWrite(i, LOW);
    }    
    // und damit er auch schön wieder in der Mitte anfängt
    pos = 4;
    up = true;
  }
}




