// #define debug
#include <debug.h>
#include <makros.h>
#include <RCReceive.h>
/*
 Startampel.ino - Formel 1 Startampel für Autorennen - Version 0.1 
 
 Copyright (c) 2013 Wilfried Klaas.  All right reserved.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/*
 Die Ausgänge sind gelbe Reihe Pin 6, grüne Reihe Pin 7, 
 Doppelleuchten in rot von links nach rechts, Pin 8..12 
 Der Empfänger wird vom Pin 2 gelesen
 Toneausgabe erfolgt am Pin 4
 */

/* Einfache Formel 1 Startampel. */

// Anschlusspin Empfänger
const byte PIN_RC = 2;

// LED Anzeigen
const byte LED_Y = 6;
const byte LED_G = 7;
const byte LED_R1 = 8;
const byte LED_R2 = 9;
const byte LED_R3 = 10;
const byte LED_R4 = 11;
const byte LED_R5 = 12;

// Tonausgabe
const byte BEEP = 4;

// Handschalter
const byte HAND_START = 0;
const byte HAND_RESET = 1;

// RC Schaltschwelle
const int SWITCH_STEP = 64;

RCReceive start;

typedef enum PHASES {
  WAIT, PREPARE, PHASE_1, PHASE_2, PHASE_3, PHASE_4, PHASE_5, START, CANCEL
};

PHASES phase;

void setup() {
  initDebug();
  dbgOutLn("Formel 1");
  pinMode(LED_Y, OUTPUT);
  digitalWrite(LED_Y, LOW);
  pinMode(LED_G, OUTPUT);
  digitalWrite(LED_G, LOW);
  pinMode(LED_R1, OUTPUT);
  digitalWrite(LED_R1, LOW);
  pinMode(LED_R2, OUTPUT);
  digitalWrite(LED_R2, LOW);
  pinMode(LED_R3, OUTPUT);
  digitalWrite(LED_R3, LOW);
  pinMode(LED_R4, OUTPUT);
  digitalWrite(LED_R4, LOW);
  pinMode(LED_R5, OUTPUT);
  digitalWrite(LED_R5, LOW);

  start.attach(PIN_RC);

  phase = WAIT;

  randomSeed(analogRead(0));

  showLights();
  doTone();  
}

// Startzeit der einzelnen Phase
unsigned long startPhase, prepareStartTime;

void loop() {
  dbgOut("phase");
  dbgOut(phase);

  // Aktuellen RC-Wert lesen
  start.poll();

  PHASES oldPhase = phase;
  byte value = 128;
  byte np = 128;
  if (start.hasNP() && !start.hasError()) {
    value = start.getValue();
    np = start.getNP();
  }

  // Handtaster und RC Signale auswerten...
  boolean isStartPressed = (value > (np + SWITCH_STEP)) || (digitalRead(HAND_START) == 0);
  boolean isResetPressed = (value < (np - SWITCH_STEP)) || (digitalRead(HAND_RESET) == 0);

  dbgOut(isStartPressed);
  dbgOut(',');
  dbgOut(isResetPressed);
  

  // Reset kann immer durchgeführt werden
  if (isResetPressed) {
    phase = WAIT;
  }

  // Ein abbruch kann immer dann durchgeführt werden, wenn das Rennen gestartet worden ist.
  if ((phase == START) && isStartPressed) {
    phase = CANCEL;
  } 

  switch (phase) {
  case WAIT:
    if (isStartPressed) {
      phase = PREPARE;
    }
    break;
  case PREPARE:
    if (millis() > (startPhase + 5000)) {
      phase = PHASE_1;
    }
    break;
  case PHASE_1:
    if (millis() > (startPhase + 1000)) {
      phase = PHASE_2;
    }
    break;
  case PHASE_2:
    if (millis() > (startPhase + 1000)) {
      phase = PHASE_3;
    }
    break;
  case PHASE_3:
    if (millis() > (startPhase + 1000)) {
      phase = PHASE_4;
    }
    break;
  case PHASE_4:
    if (millis() > (startPhase + 1000)) {
      phase = PHASE_5;
      prepareStartTime = random(200, 3000);
    }
    break;
  case PHASE_5:
    if (millis() > (startPhase + prepareStartTime)) {
      phase = START;
    }
    break;
  }

  // Licht und Tone nur ausführen, wenn sich auch der Status geändert hat.
  if (phase != oldPhase) {
    startPhase = millis();
    oldPhase = phase;
    showLights();
    doTone();
  }
  
  // Blinken bei Rennabbruch
  if (phase == CANCEL) {
    if (((millis() - startPhase) % 1000) < 500) {
      digitalWrite(LED_Y, HIGH);
    } 
    else {
      digitalWrite(LED_Y, LOW);
    }
  }
  #ifdef debug
    delay(100);
  #endif
  dbgOutLn();
}

void showLights() {
  switch (phase) {
  case WAIT:
  case PREPARE:
  case START :
    digitalWrite(LED_Y, LOW);
    digitalWrite(LED_G, LOW);
    digitalWrite(LED_R1, LOW);
    digitalWrite(LED_R2, LOW);
    digitalWrite(LED_R3, LOW);
    digitalWrite(LED_R4, LOW);
    digitalWrite(LED_R5, LOW);
    break;
  case PHASE_1:
    digitalWrite(LED_Y, LOW);
    digitalWrite(LED_G, LOW);
    digitalWrite(LED_R1, HIGH);
    digitalWrite(LED_R2, LOW);
    digitalWrite(LED_R3, LOW);
    digitalWrite(LED_R4, LOW);
    digitalWrite(LED_R5, LOW);
    break;
  case PHASE_2:
    digitalWrite(LED_Y, LOW);
    digitalWrite(LED_G, LOW);
    digitalWrite(LED_R1, HIGH);
    digitalWrite(LED_R2, HIGH);
    digitalWrite(LED_R3, LOW);
    digitalWrite(LED_R4, LOW);
    digitalWrite(LED_R5, LOW);
    break;
  case PHASE_3:
    digitalWrite(LED_Y, LOW);
    digitalWrite(LED_G, LOW);
    digitalWrite(LED_R1, HIGH);
    digitalWrite(LED_R2, HIGH);
    digitalWrite(LED_R3, HIGH);
    digitalWrite(LED_R4, LOW);
    digitalWrite(LED_R5, LOW);
    break;
  case PHASE_4:
    digitalWrite(LED_Y, LOW);
    digitalWrite(LED_G, LOW);
    digitalWrite(LED_R1, HIGH);
    digitalWrite(LED_R2, HIGH);
    digitalWrite(LED_R3, HIGH);
    digitalWrite(LED_R4, HIGH);
    digitalWrite(LED_R5, LOW);
    break;
  case PHASE_5:
    digitalWrite(LED_Y, LOW);
    digitalWrite(LED_G, LOW);
    digitalWrite(LED_R1, HIGH);
    digitalWrite(LED_R2, HIGH);
    digitalWrite(LED_R3, HIGH);
    digitalWrite(LED_R4, HIGH);
    digitalWrite(LED_R5, HIGH);
    break;
  case CANCEL:
    digitalWrite(LED_Y, HIGH);
    digitalWrite(LED_G, LOW);
    digitalWrite(LED_R1, HIGH);
    digitalWrite(LED_R2, HIGH);
    digitalWrite(LED_R3, HIGH);
    digitalWrite(LED_R4, HIGH);
    digitalWrite(LED_R5, HIGH);
    break;
  }  
}

void doTone() {
  switch (phase) {
  case PREPARE:
  case START:
  case WAIT:
    tone(BEEP, 1200, 1000);
    break;
  case PHASE_1:
  case PHASE_2:
  case PHASE_3:
  case PHASE_4:
  case PHASE_5:
    tone(BEEP, 1200, 250);
    break;
  case CANCEL:
    for (byte i = 0; i < 3; i++) {
      tone(BEEP, 1200);
      delay(500);
      tone(BEEP, 600);
      delay(500);
    }
    break;
  }  
}





