#include <debug.h>
#include <makros.h>
#include <Servo.h>
#include <RCReceive.h>
/*
  dyna_servo.ino - dynamische Servowegbegrenzung  - Version 0.1
 
 Copyright (c) 2012 Wilfried Klaas.  All right reserved.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/*
 dynamische Servowegbegrenzung. Kanal 1 ist ESC, Kanal 2 ist Steuerservo.
 Der Empfänger wird vom Pin 2 und 3 gelesen, 
 */

// Hardwareanbindung für Arduino Hardware, Empfängerkanäle
const byte PIN_RC_THR = 2;
const byte PIN_RC_STE = 3;

// Ausgänge
const byte SERVO_1 = 9; // PWM Kanal 
const byte LED = 13; // LED auf dem Board

// Stärke der Fahreinflusses auf die Steuerung
const byte control = 2;

// ------------------------------------------------------------
// AB HIER BITTE NIX MEHR ÄNDERN
// ------------------------------------------------------------
const byte ctrlM1 = control - 1;

// Laufvariable des Ringspeichers
RCReceive escReceiver;
RCReceive servoReceiver;

Servo servo;

void setup() {
  // Kanäle auf Ausgang, und dann deaktivieren
  pinMode(LED, OUTPUT);
  digitalWrite(LED, LOW);

  // Eingang für RC
  escReceiver.attachInt(PIN_RC_THR);
  servoReceiver.attachInt(PIN_RC_STE);

  // Servos definieren
  servo.attach(SERVO_1);
}

void loop() {
  // Nullpunktsbestimmung ?
  if (escReceiver.hasError() || servoReceiver.hasError()) {
    // failsafe
    servo.write(180);
  } else if (escReceiver.hasNP() && servoReceiver.hasNP()) {
    doWork();
  }
}

/*
Modus Soft berechnung, Werte werden jeweils halbiert und dann addiert.
 */
void doWork() {
  // Werte holen
  int escValue = escReceiver.getValue();;
  int servoValue = servoReceiver.getValue();;

  // Nullpunkte festlegen
  escValue = escValue - escReceiver.getNP();
  servoValue = servoValue - servoReceiver.getNP();

  // die eigentliche Berechnung
  int servo1 = servoValue ;

  // Und damit das nicht aus dem Ruder läuft, etwas begrenzen
  servo1 = constrain(servo1, -128, 128);

  float divisor  = 1 + (ctrlM1 * (abs(escValue) / 128.0));
  servo1 = servo1 / divisor;  

  // Nullpunkte wieder hinzu
  servo1 = servo1 + 128;

  // Auf den Servo umsetzen
  servo1 = map(servo1,0, 255,0,180);

  // und einstellen
  servo.write(servo1);
}
