//#define debug
#include <Servo.h>
#include <debug.h>
#include <makros.h>
#include <RCReceive.h>
/*
  Flaps.ino - Servoweg, Servoverlangsamung  - Version 0.1
 
 Copyright (c) 2012 Wilfried Klaas.  All right reserved.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/*
 Das Progam dient der Verlangsamung eines Servos, bzw. der ERzeugung eines Servoweges aus einem Schaltkanal. 
 Der Empfänger wird vom Pin 2 gelesen, 
 der Servoausgang ist auf Pin 9. 
 */

// Stellbereich de Servos
const byte SERVO_MAX = 160;
const byte SERVO_MIN = 20;

// Stellgeschwindigkeit
const byte DELTA = 1;
const byte DELAY = 10;

// EIngang Empfänger
const byte PIN_RC = 2;

// Ausgänge
const byte SERVO = 9; // PWM Kanal 
const byte LED = 13; // LED auf dem Board

// ********** Variablen **********
RCReceive rcReceiver;
Servo servo;

// Zwischenspeicher
int myRcValue;

void setup() {
  initDebug();
  // Eingang und RC Interrupthandler registrieren
  rcReceiver.attachInt(PIN_RC);
  // Servo initialisieren
  servo.attach(SERVO);
  servo.write(SERVO_MIN);
  // LED als Ausgang
  pinMode(LED, OUTPUT);
}

void loop() {
  // Fehlerfall
  if (rcReceiver.hasError()) {
    // failsafe ...
    servo.write(SERVO_MIN);
    if ((millis() % 500) < 250) {
      digitalWrite(LED,HIGH);
    } 
    else {
      digitalWrite(LED,LOW);
    }
  } 
  else if (rcReceiver.hasNP()) {
    digitalWrite(LED,HIGH);
    doWork();
  } 
}

void doWork() {
  byte sValue = rcReceiver.getValue();
  sValue = map(sValue, 0, 255, SERVO_MIN , SERVO_MAX);
  dbgOut(sValue);
  dbgOut(",");

  int aValue = servo.read();
  dbgOut(aValue);
  dbgOut(",");

  if (sValue != aValue) {
    int hValue = aValue + DELTA;
    if (hValue > SERVO_MAX) {
      hValue = SERVO_MAX;
    }
    int lValue = aValue - DELTA;
    if (lValue < SERVO_MIN) {
      lValue = SERVO_MIN;
    }
    byte dValue = constrain(sValue, lValue, hValue);

    servo.write(aValue);
    dbgOut(dValue);
    if (DELAY > 0) {
      delay(DELAY);
    }
  }
  dbgOutLn();
}


