#include "makros.h"
#include "debug.h"
#include "RCReceive.h"

/*
  Flugblitzer.ino - Programm für ACL, Strobe, Tail und Landing Lights - Version 0.1
 Copyright (c) 2013 Wilfried Klaas.  All right reserved.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

const byte PIN_ACL = 4; 
const byte PIN_STROBE = 5; 
const byte PIN_TAIL = 6; 
const byte PIN_LANDING = 7; 

const int SWITCH_STEP = 64;

const byte PIN_RC = 2; 

// Der Empfänger
RCReceive rcReceiver;

void setup() {
  // RC Interrupthandler registrieren
  rcReceiver.attachInt(PIN_RC);

  pinMode(PIN_ACL, OUTPUT);
  digitalWrite(PIN_ACL, LOW);

  pinMode(PIN_STROBE, OUTPUT);
  digitalWrite(PIN_STROBE, LOW);

  pinMode(PIN_TAIL, OUTPUT);
  digitalWrite(PIN_TAIL, LOW);

  pinMode(PIN_LANDING, OUTPUT);
  digitalWrite(PIN_LANDING, LOW);
}

void loop() {
  // nur wenn der Nullpunkt bestimmt worden ist, 
  // und es keinen Fehler gegeben hat soll die eigentliche Arbeit gemacht werden
  if (rcReceiver.hasNP() && !rcReceiver.hasError()) {
    doWork();
  } 
  else if (rcReceiver.hasError()) {
    // Fehlerbehandlung failsafe oder sowas...
  }
}

void doWork() {
  // put your main code here, to run repeatedly: 
  byte value = rcReceiver.getValue();

  doLandingLights(value);

  doACLLights();  
}

void doLandingLights(byte value) {
  if (value > (rcReceiver.getNP() + SWITCH_STEP)) {
    digitalWrite(PIN_LANDING, HIGH);   
  } 
  else {
    digitalWrite(PIN_LANDING, LOW);   
  }
}

void doACLLights() {
  unsigned long time = millis() % 1000;
  if (time < 100) {
    digitalWrite(PIN_STROBE, HIGH);   
    digitalWrite(PIN_TAIL, HIGH);   
  } 
  else if (time < 200) {
    digitalWrite(PIN_STROBE, LOW);   
    digitalWrite(PIN_TAIL, LOW);   
  } 
  else if (time < 300) {
    digitalWrite(PIN_STROBE, HIGH);   
  } 
  else if (time < 400) {
    digitalWrite(PIN_STROBE, LOW);   
  } 
  else if (time < 500) {
  } 
  else if (time < 600) {
    digitalWrite(PIN_ACL, HIGH);   
  } 
  else if (time < 700) {
    digitalWrite(PIN_ACL, LOW);   
  }
}

