
//#define debug
#include <debug.h>
#include <makros.h>
#include <RCReceive.h>
/*
 Feuerwehr.ino - Spezialanwendung für ein kleines Feuerwehrschiff. 
 Basierend auf _12Switch.ino - Version 0.1
 
 Copyright (c) 2012 Wilfried Klaas.  All right reserved.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/*
 Schaltprogramm für den Arduino für ein kleines Feuerwehrschiff. 
 Geschaltet wird auf Kanal 1 ein Blinklicht und auf Kanal 2 eine Pumpe.
 Kanal 1 Impulsbetrieb, Kanal 2 Dauerbetrieb.
 Der Empfänger wird vom Pin 2 gelesen, 
 die Ausgänge sind auf Pin 0 und 1.
 
 Impulsbetrieb: einmaliges Umlegen des Hebels schaltet ein bzw. aus
 Dauerbetrieb: das Relais ist solange geschlossen, wie der Hebel in die entsprechende Richtung gelegt wird.
 */

// Blinkzeit in ms;
const int BLINKTIME_1 = 1000; 

// Anschlusspin Empfänger
const byte PIN_RC = 2;

// Ausgänge
const byte CAN_1 = 0;
const byte CAN_2 = 1;

/* Konstante für die Erkennung des Schaltbefehls. 
 Bei Kanal 1 wäre das Nullpunkt + SWITCH_STEP bei Kanal 2 entsprechend Nullpunkt - SWITCH_STEP
 */
const int SWITCH_STEP = 64;

RCReceive rcReceiver;

// Speicher für alte Werte pro Kanal
boolean oldMustSwitch_can1 = 0;

// Zwischenspeicher
int myRcValue;
int maxSwitch;
int minSwitch;

// aktueller Schaltzustand des jeweiligen Kanals
boolean can_1_on;

void setup() {
  // Kanäle auf Ausgang, und dann deaktivieren
  pinMode(CAN_1, OUTPUT);     
  pinMode(CAN_2, OUTPUT);     
  digitalWrite(CAN_1, LOW);
  digitalWrite(CAN_2, LOW);

  // Eingang für RC
  rcReceiver.attach(PIN_RC);

  maxSwitch = 0;
  minSwitch = 0;

  can_1_on = false;
}

void loop() {
  // Aktuellen RC-Wert lesen
  rcReceiver.poll();

  // Fehlerfall
  if (rcReceiver.hasError()) {
    // failsafe ...
    can_1_on = false;
    blink1();
    digitalWrite(CAN_2, LOW);
  } 
  else if (rcReceiver.hasNP()) {
    if (maxSwitch == 0) {
      // Schaltschwellen definieren, nur wenn noch nicht definiert
      maxSwitch = rcReceiver.getNP() + SWITCH_STEP;
      minSwitch = rcReceiver.getNP() - SWITCH_STEP;
    }
    doWork();
  }
  blink1();
}

void doWork() {
  myRcValue = rcReceiver.getValue();
  // Kanal 1 auf Impuls?
  doImpuls1();

  // direkt schalten
  digitalWrite(CAN_2, myRcValue < minSwitch);
}

// Impulsschalten für Kanal 1
void doImpuls1() {
  // Änderung am Empfängerwert ?
  boolean mustSwitch = myRcValue > maxSwitch;
  if (oldMustSwitch_can1 != mustSwitch) {
    // neuen Wert schreiben, aber nur an der positiven Flanke 
    if (mustSwitch) {
      can_1_on = !can_1_on;
    }
    oldMustSwitch_can1 = mustSwitch;
  }
}

void blink1() {
  if (can_1_on) {
    if ((millis() % BLINKTIME_1) < (BLINKTIME_1 / 2)) {
      digitalWrite(CAN_1, HIGH);      
    } 
    else {
      digitalWrite(CAN_1, LOW);
    }
  } 
  else {
    digitalWrite(CAN_1, LOW);
  }
}

