#include <SoftPWM.h>
#include <SoftPWM_timer.h>
/*
  leuchtturm.ino - Rundumlichtsteuerung  - Version 0.1
 
 Copyright (c) 2012 Wilfried Klaas.  All right reserved.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/*
Leuchtturm mit 12 LED's an den Ausgängen D0..D11. Alle LED werden mit SoftPWM angesteuert,
 so kann man das Nachleuchten schön simulieren.  
 1 Taster zum Einschalten an D12. 
 Über das Array kann die Leuchtfolge bestimmt werden.
*/

// Anzahl der LED's
const byte MAX_LED = 12;
// Zeit für einen Umlauf
const int UMLAUFZEIT = 2000;
// Leuchtfolge
byte leuchtfolge[] = {
  0, 0, 0, 0, 0, 128, 255, 128, 0, 0, 0, 0};
// Schalter zum Einschalten
const byte SCHALTER = 12;

// ab hier kommen die Programmvariablen
int zeit = UMLAUFZEIT / MAX_LED;

void setup() {
  // Schalter ist Eingang mit Pullup
  pinMode(SCHALTER, INPUT_PULLUP);
  
  // Start der SoftwarePWM-Bibliothek
  SoftPWMBegin();

  // Alle LED's als OUTPUT Pins und erstmal aussschalten 
  for (int i = 0; i < MAX_LED; i++) {
    SoftPWMSet(i, 0);
  }

  // Hier kann man Zeiten definieren, damit die LED's nicht nur einfach an und aus gehen,
  // sondern schön faden.
  SoftPWMSetFadeTime(ALL, 100, 100);

}

void loop() {
 if (digitalRead(SCHALTER) == 0) {
    for (int i = 0; i < MAX_LED; i++) {
      SoftPWMSet(i, 0);
    }
  } 
  else {
    for (int i = 0; i < MAX_LED; i++) {
      SoftPWMSet(i, leuchtfolge[i]);
    }

    byte temp = leuchtfolge[0];
    for (int i = 1; i < MAX_LED; i++) {
      leuchtfolge[i-1] = leuchtfolge[i];
    }
    leuchtfolge[MAX_LED - 1] =  temp;
  }
  delay(zeit);
}
