#define debug
#include <debug.h>
#include <makros.h>
#include <RCReceive.h>
#include <Servo.h>
/*
 Mehrschrauben_Antrieb.ino - Mehrschraubenantrieb auf Basis des Kreuzmischers. - Version 0.1
 
 Copyright (c) 2012 Wilfried Klaas.  All right reserved.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */
/*
 Kanal 1 ist Geschwindigkeit, Kanal 2 ist Steuerung.
 Der Empfänger wird vom Pin 2 und 3 gelesen. 
 ESC des Motors 1 liegt auf 5, ESC des Motors 2 liegt auf 6 
 */

// Definieren der Programmkonstanten
// Tauschen des Steuereinflusses
//#define SWITCH_RUDDER_IMPACT

// Nullpunkt der beiden Regler
const byte ESC_NP_1 = 90;
const byte ESC_NP_2 = 90;

// Ab wann soll der Einfluss erfolgen (Bereich 0..128)
const byte ESC_MIN = 0;
// Wie stark soll der Einfluss sein. 
// ACHTUNG: Höhere Werte ergeben weniger Effekt
const byte RUDDER_IMPACT = 2;

// die Schleifenverzögerung, damit das alles nicht zu schnell geht
const int LOOP_DELAY = 10;

// Hardwareanbindung für Arduino Hardware
// Empfängerkanäle
const byte PIN_RC_THR = 2; // das ist INT 0 aber Pin 2!!!!
const byte PIN_RC_STE = 3; // das ist INT 1 aber Pin 3!!!!

// Ausgänge
const byte ESC_1 = 5; // PWM Kanal 
const byte ESC_2 = 6; // PWM Kanal
const byte LED = 13; // LED auf dem Board

// Ab hier nitte nichts mehr ändern.
RCReceive escReceiver;
RCReceive servoReceiver;

Servo esc1, esc2;

void setup() {
  // Kanäle auf Ausgang, und dann deaktivieren
  pinMode(LED, OUTPUT);
  digitalWrite(LED, LOW);

  // Eingang für RC und Interrupthandler registrieren
  escReceiver.attachInt(PIN_RC_THR);
  servoReceiver.attachInt(PIN_RC_STE);

  // Servos definieren
  esc1.attach(ESC_1);
  esc2.attach(ESC_2);

  esc1.write(ESC_NP_1);
  esc2.write(ESC_NP_2);  

  initDebug();
  dbgOutLn("Mehrschrauben");

  delay(100);
}

void loop() {
  if (escReceiver.hasError() || servoReceiver.hasError()) {
    // failsafe
    esc1.write(ESC_NP_1);
    esc2.write(ESC_NP_2);    
  }
  else if (escReceiver.hasNP() && servoReceiver.hasNP()) {
    doWork();
  }
  else {
    int value = escReceiver.getValue();
    value = servoReceiver.getValue();
  }
}

void doWork() {
  // Werte holen
  int escValue = escReceiver.getValue();

  // Nullpunkt festlegen
  escValue = escValue - escReceiver.getNP();
  // ab hier hat der esc_Value einen Bereich von +- 128
  int esc_value_1 = escValue;
  int esc_value_2 = escValue;

  // erst wenn der die Fahrt mehr als den minWert hat, 
  // wird der Einfluss spürbar
  if (abs(escValue) >= ESC_MIN) {
    int servoValue = servoReceiver.getValue();
    servoValue = servoValue - servoReceiver.getNP();
    // jetzt Wertebereich für den Einfluss verkleinern
    servoValue = servoValue / RUDDER_IMPACT;

    // die eigentliche Berechnung
#ifdef SWITCH_RUDDER_IMPACT
    esc_value_1 = escValue - servoValue;
    esc_value_2 = escValue + servoValue;
#else
    esc_value_1 = escValue + servoValue;
    esc_value_2 = escValue - servoValue;
#endif
    // Und damit das nicht aus dem Ruder läuft, begrenzen
    esc_value_1 = constrain(esc_value_1, -128, 128);
    esc_value_2 = constrain(esc_value_2, -128, 128);
  }
  
  // Auf die ESC's umsetzen
  esc_value_1 = map(esc_value_1,-128, 128,0,180);
  esc_value_2 = map(esc_value_2,-128, 128,0,180);

  dbgOut("ESC:");
  dbgOut(esc_value_1);
  dbgOut(",");
  dbgOutLn(esc_value_2);
  
  // und einstellen
  esc1.write(esc_value_1);
  esc2.write(esc_value_2);
  // Schleifenverzögerung
  delay(LOOP_DELAY);
}

