#include <RCReceive.h>
//#define debug
#include <Servo.h>
#include "makros.h"
#include "debug.h"

/*
  RC_Ruderer.ino - Ferngesteuertes Ruderboot - Version 0.1
 Copyright (c) 2012 Wilfried Klaas.  All right reserved.
 
 This program is free software; you can redistribute it and/or
 modify it under the terms of the GNU Lesser General Public
 License as published by the Free Software Foundation; either
 version 2.1 of the License, or (at your option) any later version.
 
 This library is distributed in the hope that it will be useful,
 but WITHOUT ANY WARRANTY; without even the implied warranty of
 MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
 Lesser General Public License for more details.
 
 You should have received a copy of the GNU Lesser General Public
 License along with this library; if not, write to the Free Software
 Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
 */

const byte PIN_ESC = 2; 
const byte PIN_RUD = 3; 

const byte RUDER_UP = 90;
const byte RUDER_DOWN = 1;
const int RUDER_DELAY = 100;

const byte PULL_MIN = 1;
const byte PULL_MAX = 180;

const int ROUND_MIN = 5000;
const int ROUND_MAX = 1500;
const byte JITTER_NP = 3;

const byte LEFTPULL = 5;
const byte LEFTLIFT = 6;
const byte RIGHTPULL = 9;
const byte RIGHTLIFT = 10;

const byte LED = 13;

// Der Empfänger
RCReceive escReceiver, rudReceiver;

// Servos der Linken Seite. Einmal zum Pullen und einmal zum Heben.
Servo srvLeftPull, srvLeftLift;
// und der rechten Seite
Servo srvRightPull, srvRightLift;

byte rcValue, rudValue;
byte maxPullLeft, maxPullRight;

void setup() {
  initDebug();
  dbgOutLn("RC Ruderer");
  delay(100);

  pinMode(LED, OUTPUT);
  digitalWrite(LED, LOW);

  escReceiver.attachInt(PIN_ESC);
  rudReceiver.attachInt(PIN_RUD);

  srvLeftPull.attach(LEFTPULL);
  srvLeftLift.attach(LEFTLIFT);

  srvRightPull.attach(RIGHTPULL);
  srvRightLift.attach(RIGHTLIFT);

  nop();
}

void loop() {
  if (escReceiver.hasError() || rudReceiver.hasError()) {
    nop();
    dbgOutLn("error");
    if ((millis() % 500) < 250) {
      digitalWrite(LED, HIGH);
    } 
    else {
      digitalWrite(LED, LOW);
    }
    delay(100);
  }  
  else if (escReceiver.hasNP() && rudReceiver.hasNP()) {
    digitalWrite(LED, HIGH);
    doWork();
  }
  else {
    int value = escReceiver.getValue();
    value = rudReceiver.getValue();
    if ((millis() % 500) < 250) {
      digitalWrite(LED, HIGH);
    } 
    else {
      digitalWrite(LED, LOW);
    }
  }
}

unsigned long lastStart = 0; 
typedef enum STATE { 
  PULL, LIFT};
STATE state;

int roundTime;
int halfTime ;
byte svPosLeft, svPosRight;

void doWork() {
  if (rcValue > (escReceiver.getNP()+JITTER_NP)) {
    // wir fahren vorwärts
    boolean forward = true; 

    unsigned long time = millis();
    if (lastStart == 0) {
      lastStart = time;
    } 
    else {
      time = time - lastStart;
    }
    dbgOut("Time:");
    dbgOut(time);    
    dbgOutLn();    
    // Sind wir beim ziehen oder beim zurückholen?
    if (time <= halfTime) {
      state = PULL;
      dbgOutLn("pull");
      if (srvLeftLift.read() != RUDER_DOWN) {
        srvLeftLift.write(RUDER_DOWN);
      }
      if (srvRightLift.read() != RUDER_DOWN) {
        srvRightLift.write(RUDER_DOWN);
        delay(RUDER_DELAY);
      }

      // beim ziehen
      int posLeft = map(time, 0, halfTime, PULL_MIN, maxPullLeft); 
      srvLeftPull.write(posLeft);
      svPosLeft = posLeft;

      int posRight = map(time, 0, halfTime, PULL_MIN, maxPullRight); 
      srvRightPull.write(posRight);
      svPosRight = posRight;
    } 
    else {
      // beim zurück holen
      dbgOut("back:");

      if (srvLeftLift.read() != RUDER_UP) {
        srvLeftLift.write(RUDER_UP);
      }
      if (srvRightLift.read() != RUDER_UP) {
        srvRightLift.write(RUDER_UP);
        delay(RUDER_DELAY);
      }

      if (state == PULL) {
        // Beim ersten durchlauf von Lift den neuen RC Wert holen und verarbeiten
        state = LIFT;
        readRc();
        lastStart = lastStart + time - halfTime;
      }
      time = time - halfTime;
      int posLeft = map(time, 0, halfTime, svPosLeft, PULL_MIN); 
      dbgOut(posLeft);
      srvLeftPull.write(posLeft);
      dbgOut(",");
      int posRight = map(time, 0, halfTime, svPosRight, PULL_MIN); 
      dbgOut(posRight);
      srvRightPull.write(posRight);

      dbgOutLn();
      time = time + halfTime;
    }
    if (time > roundTime) {
      readRc();
      lastStart = millis();
      dbgOutLn("new round");
    } 
  } 
  else {
    dbgOutLn("null");
    dbgOut("RCValue:");
    dbgOutLn(rcValue);
    nop();
    readRc();
    delay(100);
    lastStart = 0;
  }
}

void nop() {
  srvLeftLift.write(RUDER_UP);
  srvRightLift.write(RUDER_UP);
  srvLeftPull.write(PULL_MIN);
  srvRightPull.write(PULL_MIN);
}

void readRc() {
  rcValue = escReceiver.getValue();
  // Rundenzeit berechnen
  roundTime = map(rcValue, escReceiver.getNP(), 255, ROUND_MIN, ROUND_MAX);
  // halbe Zeit
  halfTime = roundTime / 2;

  // Ausschlagkorrektur zum Lenken 
  rudValue = rudReceiver.getValue();
  if (rudValue > 128) {
    maxPullRight = PULL_MAX;
    maxPullLeft = map(rudValue, 128,255, PULL_MAX, PULL_MIN);
  } 
  else {
    maxPullRight = map(rudValue, 128, 0, PULL_MAX, PULL_MIN);
    maxPullLeft = PULL_MAX;
  }

  dbgOut("Times:");
  dbgOut(roundTime);
  dbgOut(",");
  dbgOutLn(halfTime);    

  dbgOut("Rudder:");
  dbgOut(maxPullRight);
  dbgOut(",");
  dbgOutLn(maxPullLeft);    
}


