#include <inttypes.h>
/*
  RCReceive.h - Auslesen eine RC Empfängers - Version 0.1
  Copyright (c) 2012 Wilfried Klaas.  All right reserved.

  This library is free software; you can redistribute it and/or
  modify it under the terms of the GNU Lesser General Public
  License as published by the Free Software Foundation; either
  version 2.1 of the License, or (at your option) any later version.

  This library is distributed in the hope that it will be useful,
  but WITHOUT ANY WARRANTY; without even the implied warranty of
  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
  Lesser General Public License for more details.

  You should have received a copy of the GNU Lesser General Public
  License along with this library; if not, write to the Free Software
  Foundation, Inc., 51 Franklin St, Fifth Floor, Boston, MA  02110-1301  USA
*/

// Konstanten für die RC Erkennung
const uint16_t MIN_RC_VALUE = 900;
const uint16_t MAX_RC_VALUE = 2100;
const uint8_t MAX_ERROR_COUNT = 3;

// Größe des Pufferspeichers
const uint8_t stackSize = 10;

typedef struct  {
  volatile uint16_t stack[stackSize];
  // Laufvariable des Ringspeichers
  uint8_t index; 
} 
sStack;

// Die Klasse für den Empfänger
class RCReceive 
{
public: 
  static void initInt();
  
  RCReceive();
  
  // Empfngerklasse mit Pin verbinden
  void attach(uint8_t pin);

  // aktuellen gemittelten Wert besorgen
  uint8_t getValue();

  // neuen Wert einlesen
  uint8_t poll();

  // Nullpunkt holen
  uint8_t getNP();  

  // Fehler Status
  uint8_t hasError();

  // Nullpunkt wurde bestimmt
  uint8_t hasNP();

  // Letzten gelesenen Wert ausgeben
  unsigned int getLastRCValue();

  // vereinfachung für die Interruptroutine
  void handleInterrupt();

  // Interruptbetrieb mit interner zuweisen
  void attachInt(uint8_t pin);
  
  // eigene Interruptroutine zuweisen
  void attachInt(void (*handler)(void));

  // Pin und eigene Interruptroutine zuweisen
  void attachInt(uint8_t pin, void (*handler)(void));

  // zugewiesenen Interruptroutine lösen
  void detachInt();

  // aktuellen gemittelten Wert in ms besorgen
  uint16_t getMsValue();
private:
  volatile unsigned int lastValue;
  sStack myStack;
  uint8_t myPin;
  uint8_t nullpoint;
  // die unteren 4 Bit geben die Anzahl der Fehler, 
  // das oberste Bit gibt an, ob der Nullpunkt bestimmt wurde.
  volatile uint8_t state;
  volatile uint16_t RcTemp;
  bool hasValue;
  bool isIntMode;
  unsigned long lastValueTime;
};
